VERSION 5.00
Object = "{4DE9E2A3-150F-11CF-8FBF-444553540000}#4.0#0"; "DlxOCX32.ocx"
Begin VB.Form Form1 
   Caption         =   "Retriggerable Pulse Generation with KPCI-3108"
   ClientHeight    =   4530
   ClientLeft      =   2070
   ClientTop       =   1920
   ClientWidth     =   6240
   LinkTopic       =   "Form1"
   ScaleHeight     =   4530
   ScaleWidth      =   6240
   Begin VB.TextBox txtPulseWidth 
      Height          =   285
      Left            =   2400
      TabIndex        =   11
      Text            =   "100"
      ToolTipText     =   "Value can not exceed 65535"
      Top             =   1320
      Width           =   975
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "Exit"
      Height          =   375
      Left            =   5160
      TabIndex        =   9
      Top             =   3960
      Width           =   855
   End
   Begin VB.ComboBox cboDevice 
      Height          =   315
      Left            =   2400
      TabIndex        =   6
      Top             =   720
      Width           =   735
   End
   Begin VB.CommandButton cmdHelp 
      Caption         =   "Help"
      Height          =   375
      Left            =   600
      TabIndex        =   5
      Top             =   3120
      Width           =   1455
   End
   Begin VB.CommandButton cmdStop 
      Caption         =   "Stop"
      Height          =   375
      Left            =   600
      TabIndex        =   4
      Top             =   2520
      Width           =   1455
   End
   Begin VB.CommandButton cmdStart 
      Caption         =   "Start"
      Height          =   375
      Left            =   600
      TabIndex        =   2
      Top             =   1920
      Width           =   1455
   End
   Begin VB.CommandButton cmdConfig 
      Caption         =   "Configure CT0"
      Height          =   375
      Left            =   600
      TabIndex        =   1
      Top             =   1320
      Width           =   1455
   End
   Begin VB.CommandButton cmdInit 
      Caption         =   "Initialize"
      Height          =   375
      Left            =   600
      TabIndex        =   0
      Top             =   720
      Width           =   1455
   End
   Begin DlsrLib.DriverLINXSR SRCT 
      Left            =   4560
      Top             =   120
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.Label Label3 
      Caption         =   $"frmMain.frx":0000
      Height          =   975
      Left            =   2520
      TabIndex        =   10
      Top             =   2520
      Width           =   3255
   End
   Begin VB.Label lblStatus 
      BackColor       =   &H8000000E&
      Height          =   375
      Left            =   2520
      TabIndex        =   8
      Top             =   2040
      Width           =   3375
   End
   Begin VB.Label Label2 
      Caption         =   "Device Number: "
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   2400
      TabIndex        =   7
      Top             =   480
      Width           =   1335
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      BackColor       =   &H000000FF&
      Caption         =   "  KEITHLEY  "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H8000000E&
      Height          =   300
      Left            =   480
      TabIndex        =   3
      Top             =   240
      Width           =   1605
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
'
' tested on Win2K SP4 with 3108-850A04 using VB6
' apply an edge at gate of CT0, pin 19.
' witness active low pulse of programmed duration at pin 6
' but only if the configuration has been done!

Private Sub cmdConfig_Click()
With SRCT
   ' 82C54 of KPCI-3108 in hardware mode 1
   ' retriggerable one-shot
   .Req_op = DL_CONFIGURE
   .Req_mode = DL_OTHER
   .Req_subsystem = DL_CT
   .Evt_Tim_type = DL_RATEEVENT
   .Evt_Tim_rateChannel = 1   ' physical hardware counter 0
   .Evt_Tim_rateClock = DL_INTERNAL5  ' Internal5 = 100KHz timebase
   '
   '  KPCI-3108 has INTERNAL1 through INTERNAL5 timebases available
   '
   .Evt_Tim_rateGate = HIEDGEGATEN  ' only rising edge is supported
   .Evt_Tim_rateMode = DL_RETRIGONESHOT
   .Evt_Tim_rateOnCount = 0
   .Evt_Tim_rateOutput = CT_Output_Default
   .Evt_Tim_ratePeriod = CLng(txtPulseWidth.Text)  '100 / 100KHz timebase = duration of the active low pulse
   ' since this is a single 16 bit counter, valid value for ratePeriod can not exceed 65535
   ' this is number of tics of the selected timebase which controls the duration of the
   ' active low pulse
   '
   .Evt_Tim_ratePulses = 1
   .Sel_chan_N = 0  ' add this cause got invalid starting channel error on re-config
   .Refresh
End With
lblStatus.Caption = "Config Status: " & SRCT.Message
' KPCI-3108 has several internal timebases that can be used for the rate clock:
' Internal1 = as configured in DLinx Config but is 5MHz by default
' Internal2 = 10MHz
' Internal3 =  5MHz
' Internal4 =  1MHz
' Internal5 = 100KHz'
' ratePeriod property can be as much as 65535.
'
' Use combination of rateClock and ratePeriod to control the duration of the active low pulse
End Sub

Private Sub cmdExit_Click()
' just in case, stop any task that might be active
With SRCT
   .Req_op = DL_STOP
   .Refresh
End With
' now unload the DLL (no memory leaks)
SRCT.Req_DLL_name = ""
End  ' close the program
End Sub

Private Sub cmdHelp_Click()
Form2.Show
Form1.Hide
End Sub

Private Sub cmdInit_Click()
With SRCT
.Req_DLL_name = "kpci3108$"  ' only suitable for KPCI-3108 or KPCI-3107 boards
.Req_device = cboDevice.ListIndex
.Req_op = DL_INITIALIZE
.Req_subsystem = DL_DEVICE
.Req_mode = DL_OTHER
.Refresh
End With
lblStatus.Caption = "Init Status: " & SRCT.Message

If SRCT.Message = "No error" Then
'do this
Else
' do that
End If
Form1.SetFocus  ' set focus back to our dialog
End Sub

Private Sub cmdStart_Click()
If Not IsTaskActive(SRCT) Then

With SRCT
   .Req_op = DL_START
   .Req_mode = DL_POLLED
   .Req_subsystem = DL_CT
   .Evt_Tim_type = DL_NULLEVENT
   .Evt_Str_type = DL_NULLEVENT
   .Evt_Stp_type = DL_NULLEVENT
   .Sel_chan_N = 1
   .Sel_chan_start = 1
   .Sel_chan_format = DL_tNATIVE
   .Sel_buf_N = 0
   .Sel_buf_size = 0
   .Res_Sta_typeStatus = DL_TIMERSTATUS ' return timer status info for status operations
   .Refresh
   lblStatus.Caption = "Start Status: " & .Message
   End With
Else
lblStatus.Caption = "Start Status: " & SRCT.Message
End If
End Sub

Private Sub cmdStop_Click()
With SRCT
   .Req_op = DL_STOP
   .Refresh
End With
lblStatus.Caption = "Stop Status: " & SRCT.Message
End Sub

Private Sub Form_Load()
Dim i As Integer
For i = 0 To 5
cboDevice.AddItem Str(i), i
Next i
cboDevice.ListIndex = 0 ' set equal to first entry
End Sub

Private Function IsTaskActive(ByVal SR As DriverLINXSR) As Boolean
    Dim OldOp As DlsrLib.Req_opConstants
    OldOp = SR.Req_op
    SR.Req_op = DL_STATUS
    SR.Refresh
    'Debug.Assert (SR.Res_result = DL_NoErr) Or (SR.Res_result = DL_NotTaskErr)
'    Debug.Print "Status error:" & SR.Message
    IsTaskActive = (SR.Res_result = DL_NoErr)
    SR.Req_op = OldOp
End Function
